---
title: UI elements · Cloudflare Style Guide
description: UI elements are the interactive parts of a product. They are used
  to build the software's interface. When describing UI elements in writing, we
  focus on what users need to do without focusing on the UI.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/formatting/ui-elements/
  md: https://developers.cloudflare.com/style-guide/formatting/ui-elements/index.md
---

UI elements are the interactive parts of a product. They are used to build the software's interface. When describing UI elements in writing, we focus on what users need to do without focusing on the UI.

To clarify instructions for complex interfaces, you may need to identify elements by name.

| UI element | Usage | Example |
| - | - | - |
| Button | Select **Add a Site**. | ![Blue button to add a site.](https://developers.cloudflare.com/_astro/button.CukzAuRs_2e4OI.webp) |
| Checkboxes and radio buttons | Turn **Set as Default DNS Location** on. | ![Two checkboxes for setting DNS options.](https://developers.cloudflare.com/_astro/checkbox.C5zEt3Gs_1bDyO8.webp) |
| Commands | Go to **File**, then select **Delete**. | ![Command options to edit or delete.](https://developers.cloudflare.com/_astro/command.BrUyCUbA_OXaVW.webp) |
| Error message | If you receive the error message `Invalid IP`, start the process from the beginning. | ![Invalid IP address input.](https://developers.cloudflare.com/_astro/error-message.BSYNSeRJ_NxuG2.webp) |
| Menu | In the menu, go to your account > **Websites**. | ![List of website options.](https://developers.cloudflare.com/_astro/menu.BjerjH23_Z1iinKX.webp) |
| Tab | Go to **Action**. | ![Tabs with security event categories.](https://developers.cloudflare.com/_astro/tab.CoV0ZLwZ_Z23zv3E.webp) |
| Toggle | Turn **AV inspection** on. | ![Toggle to turn anti-virus inspection on.](https://developers.cloudflare.com/_astro/toggle.BE_wg5zq_2vDFW9.webp) |
| Containers (windows, screens, pages, sections, and cards) | Refer to your site's traffic statistics for more information. | ![Information container with website statistics.](https://developers.cloudflare.com/_astro/container.CwJ0MSRs_Z1a1v3E.webp) |

## Interactions

When describing navigation elements, such as menus, use `go to` instead of `navigate`. When describing elements you can activate, such as checkboxes and toggles, use `turn on`/`turn off` instead of `enable`/`disable`.

For information on physical inputs, such as mouse buttons, refer to [Keyboard keys](https://developers.cloudflare.com/style-guide/formatting/keyboard-keys/).

## Symbols in UI element names

### Icons or non-alphabetic characters

The names or labels on buttons and other UI elements may include icons or symbols. For example, a button named **+ Add element** includes a plus sign. When writing these names or labels in procedures, do not include symbols. They are usually redundant and can be removed safely.

If an element has no text other than the symbol (for example, just `+`), you can keep the symbol in the instructions. This especially applies to instructions in interfaces for third-party products.

### Ellipses

An ellipsis is a set of three dots (`...`) that might be used as a variable or wildcard. For example, a **Save As...** menu item might display a dialog box where you can save a file in different places. If you refer to a menu item or button that has an ellipsis, do not include the ellipsis. In text, ellipses can be distracting.
