---
title: Block requests by attack score · Cloudflare Web Application Firewall (WAF) docs
description: The attack score helps identify variations of known attacks and
  their malicious payloads.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/block-attack-score/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/block-attack-score/index.md
---

The [attack score](https://developers.cloudflare.com/waf/detections/attack-score/) helps identify variations of known attacks and their malicious payloads.

This example custom rule blocks requests based on country code ([ISO 3166-1 Alpha 2](https://www.iso.org/obp/ui/#search/code/) format), from requests with an attack score lower than 20. For more information, refer to [WAF attack score](https://developers.cloudflare.com/waf/detections/attack-score/).

* **Expression**: `(ip.src.country in {"CN" "TW" "US" "GB"} and cf.waf.score lt 20)`
* **Action**: *Block*
