---
title: Firewall for AI (beta) · Cloudflare Web Application Firewall (WAF) docs
description: "Firewall for AI is a detection that can help protect your services
  powered by large language models (LLMs) against abuse. This model-agnostic
  detection currently helps you do the following:"
lastUpdated: 2025-11-06T19:39:43.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/waf/detections/firewall-for-ai/
  md: https://developers.cloudflare.com/waf/detections/firewall-for-ai/index.md
---

Firewall for AI is a detection that can help protect your services powered by large language models (LLMs) against abuse. This model-agnostic detection currently helps you do the following:

* Prevent data leaks of personally identifiable information (PII) — for example, phone numbers, email addresses, social security numbers, and credit card numbers.
* Detect and moderate unsafe or harmful prompts – for example, prompts potentially related to violent crimes.
* Detect prompts intentionally designed to subvert the intended behavior of the LLM as specified by the developer – for example, prompt injection attacks.

When enabled, the detection runs on incoming traffic, searching for any LLM prompts attempting to exploit the model. Currently, the detection only handles requests with a JSON content type (`application/json`).

Cloudflare will populate the existing [Firewall for AI fields](https://developers.cloudflare.com/waf/detections/firewall-for-ai/fields/) based on the scan results. You can check these results in the [Security Analytics](https://developers.cloudflare.com/waf/analytics/security-analytics/) dashboard by filtering on the `cf-llm` [managed endpoint label](https://developers.cloudflare.com/api-shield/management-and-monitoring/endpoint-labels/) and reviewing the detection results on your traffic. Additionally, you can use these fields in rule expressions ([custom rules](https://developers.cloudflare.com/waf/custom-rules/) or [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/)) to protect your application against LLM abuse and data leaks.

## Availability

Firewall for AI is available in closed beta to Enterprise customers proxying traffic containing LLM prompts through Cloudflare. Contact your account team to get access.

## More resources

* [Cloudflare AI Gateway](https://developers.cloudflare.com/ai-gateway/)
* [Learning Center: What are the OWASP Top 10 risks for LLMs?](https://www.cloudflare.com/learning/ai/owasp-top-10-risks-for-llms/)
